#include <bits/extc++.h>

using namespace std;

using ll = long long;
using ull = unsigned long long;
using ii = pair<ll, ll>;
using vi = vector<ll>;
using vii = vector<ii>;
using vb = vector<bool>;
using vc = vector<char>;
using vvi = vector<vi>;
using vvc = vector<vc>;
using vvii = vector<vii>;
using vvb = vector<vector<bool>>;

template<typename T, typename Y>
istream& operator>>(istream& s, pair<T, Y>& v) {
  return s >> v.first >> v.second;
}

template<typename T>
istream& operator>>(istream& s, vector<T>& v) {
  for (auto& e : v) s >> e;
  return s;
}

template<typename T>
ostream& operator<<(ostream& s, const vector<T>& v) {
  for (const auto& e : v) s << e << ' ';
  return s;
}

bool solve();

int main() {
#ifdef DEBUG
  freopen("../in.txt", "r", stdin);
  freopen("../out.txt", "w", stdout);
#endif

  ios_base::sync_with_stdio(false);
  cin.tie(nullptr);
  cout.setf(ios::fixed);
  cout.precision(20);

  ll t;
  cin >> t;
  while (solve());
}

template<class T>
struct vec2 {
  vec2() : vec2(0, 0) {}
  vec2(T x, T y) : x(x), y(y) {}
  vec2(const vec2& a, const vec2& b) : vec2(b - a) {}
  vec2 operator+(const vec2& other) const {
    return vec2{x + other.x, y + other.y};
  }
  vec2 operator-(const vec2& other) const {
    return vec2{x - other.x, y - other.y};
  }

  friend istream& operator>>(istream& s, vec2& self) {
    return s >> self.x >> self.y;
  }

  T cross(const vec2& other) const {
    return x * other.y - y * other.x;
  }

  T dot(const vec2& other) const {
    return x * other.x + y * other.y;
  }

  bool operator==(const vec2& other) const {
    return x == other.x && y == other.y;
  }

  bool zero() const {
    return x == 0 && y == 0;
  }

  T x;
  T y;
};

using vec = vec2<ll>;

bool counterclockwise(const vec& a, const vec& b, bool strict) {
  if (strict) return a.cross(b) < 0;
  else return a.cross(b) <= 0;
}

ll dir_side(const vec& a, const vec& b) {
  ll v = a.dot(b);
  if (v > 0) return 1;
  if (v < 0) return -1;
  return 0;
}

ll side(const vec& a, const vec& b) {
  ll v = a.cross(b);
  if (v < 0) return -1;
  if (v > 0) return 1;
  return 0;
}

bool clockwise(const vec& a, const vec& b, bool strict) {
  if (strict) return a.cross(b) > 0;
  else return a.cross(b) >= 0;
}

bool within_angle_ordered(const vec& a, const vec& b, const vec& c, bool strict) {
  return counterclockwise(a, b, strict) && counterclockwise(c, a, strict);
}

bool within_angle(const vec& a, const vec& b, const vec& c, bool strict) {
//  if (c.cross(b)==0 && strict) return a.cross()
  if (a.zero() || b.zero() || c.zero()) {
    return !strict;
  }
  if (counterclockwise(c, b, true)) {
    return within_angle_ordered(a, b, c, strict);
  } else if (counterclockwise(b, c, true)) {
    return within_angle_ordered(a, c, b, strict);
  } else {
    return true;
  }
}

bool within_segment(const vec& a, const vec& b, const vec& c, bool strict) {
  if (side(vec(a, b), vec(a, c)) != 0) return false;
  if (strict && (a == b || a == c)) return false;
  ll s = dir_side(vec(a, b), vec(a, c));
  return s != 1;
}

bool intersect(const vec& a, const vec& b, const vec& c, const vec& d) {
  if (side(vec(a, b), vec(a, c)) == 0 && side(vec(a, b), vec(a, d)) == 0) {
    return within_segment(c, a, b, false)
        || within_segment(d, a, b, false)
        || within_segment(a, c, d, false)
        || within_segment(b, c, d, false);
  }
  return within_angle(vec(a, b), vec(a, c), vec(a, d), false)
      && within_angle(vec(b, a), vec(b, c), vec(b, d), false)
      && within_angle(vec(c, d), vec(c, a), vec(c, b), false)
      && within_angle(vec(d, c), vec(d, a), vec(d, b), false);
}

vvi gr;
vi used;
ll ans;

vi path;

void dfs(ll v, ll par = -1) {
  path.emplace_back(v + 1);
  used[v] = 1;
  for (auto u : gr[v]) {
    if (u == par) continue;
    if (used[u] == 0) dfs(u, v);
    else if (used[u] == 1) {
      ans += 1;
      path.emplace_back(u + 1);
//      cout << "path: " << path << endl;
      path.pop_back();
    }
  }
  used[v] = 2;
  path.pop_back();
}

bool solve() {
  ll n;
  if (!(cin >> n)) return false;

  vector<pair<vec, vec>> a(n);
  cin >> a;

  ans = 0;
  gr.assign(n, {});
  used.assign(n, 0);

  for (int i = 0; i < n; ++i) {
    for (int j = i + 1; j < n; ++j) {
      if (intersect(a[i].first, a[i].second, a[j].first, a[j].second)) {
#ifdef DEBUG
        cout << i + 1 << ' ' << j + 1 << " has intersection" << endl;
#endif
        gr[i].emplace_back(j);
        gr[j].emplace_back(i);
      }
    }
  }

  for (int i = 0; i < n; ++i) {
    if (used[i] == 0) {
      dfs(i);
    }
  }

  cout << ans + 1 << endl;

  return true;
}